/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.watch.get;

import com.floragunn.searchguard.user.User;
import com.floragunn.signals.NoSuchTenantException;
import com.floragunn.signals.Signals;
import com.floragunn.signals.SignalsTenant;
import com.floragunn.signals.SignalsUnavailableException;
import com.floragunn.signals.actions.watch.get.GetWatchRequest;
import com.floragunn.signals.actions.watch.get.GetWatchResponse;
import com.floragunn.signals.watch.Watch;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetWatchAction
extends HandledTransportAction<GetWatchRequest, GetWatchResponse> {
    private final Signals signals;
    private final Client client;
    private final ThreadPool threadPool;

    @Inject
    public TransportGetWatchAction(Signals signals, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, Client client) {
        super("cluster:admin:searchguard:tenant:signals:watch/get", transportService, actionFilters, GetWatchRequest::new);
        this.signals = signals;
        this.client = client;
        this.threadPool = threadPool;
    }

    protected final void doExecute(Task task, GetWatchRequest request, final ActionListener<GetWatchResponse> listener) {
        try {
            ThreadContext threadContext = this.threadPool.getThreadContext();
            User user = (User)threadContext.getTransient("_sg_user");
            Object remoteAddress = threadContext.getTransient("_sg_remote_address");
            Object origin = threadContext.getTransient("_sg_origin");
            final SignalsTenant signalsTenant = this.signals.getTenant(user);
            try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
                threadContext.putHeader("_sg_conf_request", "true");
                threadContext.putTransient("_sg_user", (Object)user);
                threadContext.putTransient("_sg_remote_address", remoteAddress);
                threadContext.putTransient("_sg_origin", origin);
                ((GetRequestBuilder)this.client.prepareGet().setIndex(signalsTenant.getConfigIndexName())).setId(signalsTenant.getWatchIdForConfigIndex(request.getWatchId())).setFetchSource(Strings.EMPTY_ARRAY, Watch.HiddenAttributes.asArray()).execute((ActionListener)new ActionListener<GetResponse>(){

                    public void onResponse(GetResponse response) {
                        listener.onResponse((Object)new GetWatchResponse(signalsTenant.getName(), response));
                    }

                    public void onFailure(Exception e) {
                        listener.onFailure(e);
                    }
                });
            }
        }
        catch (NoSuchTenantException e) {
            listener.onResponse((Object)new GetWatchResponse(e.getTenant(), request.getWatchId(), false));
        }
        catch (SignalsUnavailableException e) {
            listener.onFailure((Exception)((Object)e.toElasticsearchException()));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

